<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/displaytag-12.tld" prefix="display" %>
<%@ taglib uri="netui-tags-html.tld" prefix="netui-compat"%>
<%@ taglib uri="netui-tags-template.tld" prefix="netui-compat-template"%>
<%@ taglib uri="netui-tags-databinding.tld" prefix="netui-compat-data"%>
<%@ taglib uri="http://beehive.apache.org/netui/tags-html-1.0" prefix="netui" %>

<c:set var="showUpdatingMsg" value="true" />
<c:set var="pageHelp" value="${pageFlow.summaryHelpURI}" />
<c:set var="printerFriendlyPageAction" value="viewPrinterFriendlyIndex" />

<%@ include file="pageHeader.jspf" %>

<%@ include file="indexDescription.jspf" %>
<netui-compat-template:visible negate="true" visibility="{pageFlow.populated}">
<p>No allergies and adverse reaction records were found.</p>
</netui-compat-template:visible>

<netui-compat-template:visible visibility="{pageFlow.populated}">
<p>
The following lists all of your allergies and adverse reactions from your VA facilities.
Select an allergen/reactant to view the details.
</p>
</netui-compat-template:visible>


<netui:form id="allergySource" action="allergySource" tagId="allergySource">
 <div id="filterFields">
  <h4>Filter Result</h4>
  <p>Select a source below and click the "Go" button to view the results.</p>
  <table width="100%" border="0">
   <tr>
    <td width="31%" height="137">
	 <div class="filterField" id="allergySource">
	 <fieldset>
      <legend>Source</legend>
        <table width="100%" border="0">
            <tr>   
        	    <netui:radioButtonGroup dataSource="actionForm.allergySource" defaultValue="V">
                <td>
        			<netui:radioButtonOption tagId="showSourceVA" value="V">&nbsp;<label for="showSourceVA">VA </label></netui:radioButtonOption>
				</td>
			</tr>
			<tr>
        		<td>
			    	<netui:radioButtonOption tagId="showSourceNonVA" value="NV">&nbsp;<label for="showSourceNonVA">Self-entered</label></netui:radioButtonOption>
			    </td>
			</tr>
			<tr>
				<td>
			    	<netui:radioButtonOption tagId="showSourceBoth" value="B">&nbsp;<label for="showSourceBoth">Both</label></netui:radioButtonOption>
			    </td>
			</tr>
          </table>
              </netui:radioButtonGroup>
	 </fieldset></div></td>
     <td width="69%" valign="bottom">
		<netui:button alt="Go" title="Go" value="Go" action="allergySource"/>
	 </td>
   </tr>
   </table>
</netui:form>

<p>
	<display:table id="${pageFlow.tableUID}" 
	    uid="${pageFlow.tableUID}" 
		name="${pageFlow.extractAllergyTableDecorators}"
	    pagesize="10" 
	    sort="list"
	    defaultsort="${pageFlow.defaultSortProperty}" 
	    defaultorder="${pageFlow.defaultSortOrder.name}"
	    requestURI="handlePagingAndSorting.do">
	    <display:setProperty name="custom.sort.class" 
            value="${pageFlow.sortClassName}" />
	    <display:setProperty name="paging.banner.item_name" 
	    	value="item" />
	    <display:setProperty name="paging.banner.items_name" 
	    	value="items" />
    	<display:setProperty name="basic.msg.empty_list"
	    	value="No records found." />            
    	<display:setProperty name="basic.msg.empty_list_row"
	    	value='<tr class="empty"><td colspan="{0}">No records found.</td></tr>' />
	    		
		<display:column property="collectedOn" sortable="true" 
		    sortProperty="collectedOnDate" title="Date Entered" width="15%"/>
		<display:column property="reactant" sortable="true" 
			title="Allergen/Reactant" href="viewDetails.do" 
			paramId="id" paramProperty="id" width="20%"/>
		<display:column property="allergyReaction" sortable="true" title="Reaction/Side Effect" width="35%"/>
		<display:column property="facilityName" sortable="true" 
		    title="Location" width="15%"/>
		<display:column property="allergySource" sortable="true" title="Source" width="10%"/>		    
	</display:table>
	<netui-compat-template:visible negate="true" visibility="{pageFlow.populated}">
		0 Allergies and Adverse Reactions records found.
	</netui-compat-template:visible>
</p>

<br>
<%@ include file="goldStandardText.jspf"%>
<br>

<%@ include file="../../common/pageFooter.jspf" %>